/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.data.AdvancementData;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.data.TickingData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class DataStorage {
    public static final String ID_OLD = "Lootr-AdvancementData";
    public static final String SCORED_OLD = "Lootr-ScoreData";
    public static final String DECAY_OLD = "Lootr-DecayData";
    public static final String REFRESH_OLD = "Lootr-RefreshData";
    public static final String ID = "lootr/Lootr-AdvancementData";
    public static final String SCORED = "lootr/Lootr-ScoreData";
    public static final String DECAY = "lootr/Lootr-DecayData";
    public static final String REFRESH = "lootr/Lootr-RefreshData";

    @Nullable
    public static DimensionDataStorage getDataStorage() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        ServerLevel overworld = server.m_129783_();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.m_8895_();
    }

    public static boolean isAwarded(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, ID);
        return data.contains(player, tileId);
    }

    public static void award(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, ID);
        data.add(player, tileId);
        data.m_77762_();
    }

    public static boolean isScored(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, SCORED);
        return data.contains(player, tileId);
    }

    public static void score(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, SCORED);
        data.add(player, tileId);
        data.m_77762_();
    }

    public static int getDecayValue(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        return data.getValue(id);
    }

    public static boolean isDecayed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        return data.isComplete(id);
    }

    public static void setDecaying(UUID id, int decay) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        data.setValue(id, decay);
        data.m_77762_();
    }

    public static void removeDecayed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        if (data.remove(id) != -1) {
            data.m_77762_();
        }
    }

    public static void doDecay() {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        if (data.tick()) {
            data.m_77762_();
        }
    }

    public static int getRefreshValue(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        return data.getValue(id);
    }

    public static boolean isRefreshed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        return data.isComplete(id);
    }

    public static void setRefreshing(UUID id, int decay) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        data.setValue(id, decay);
        data.m_77762_();
    }

    public static void removeRefreshed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        if (data.remove(id) != -1) {
            data.m_77762_();
        }
    }

    public static void doRefresh() {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        if (data.tick()) {
            data.m_77762_();
        }
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static ChestData getInstanceUuid(ServerLevel world, BlockPos pos, UUID id) {
        return DataStorage.getContainerData(world, pos, id);
    }

    public static ChestData getContainerData(ServerLevel world, BlockPos pos, UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.m_46472_() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        return ChestData.unwrap((ChestData)manager.m_164861_(ChestData.loadWrapper(id, (ResourceKey<Level>)world.m_46472_(), pos), ChestData.id((ResourceKey<Level>)world.m_46472_(), pos, id), ChestData.ID(id)), id, (ResourceKey<Level>)world.m_46472_(), pos);
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static ChestData getInstance(ServerLevel world, BlockPos pos, UUID id) {
        return DataStorage.getEntityData(world, pos, id);
    }

    public static ChestData getEntityData(ServerLevel world, BlockPos pos, UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.m_46472_() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        return ChestData.unwrap((ChestData)manager.m_164861_(ChestData.loadWrapper(id, (ResourceKey<Level>)world.m_46472_(), pos), ChestData.entity((ResourceKey<Level>)world.m_46472_(), pos, id), ChestData.ID(id)), id, (ResourceKey<Level>)world.m_46472_(), pos);
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static ChestData getInstanceInventory(ServerLevel world, BlockPos pos, UUID id, NonNullList<ItemStack> base) {
        return DataStorage.getReferenceContainerData(world, pos, id, base);
    }

    public static ChestData getReferenceContainerData(ServerLevel world, BlockPos pos, UUID id, NonNullList<ItemStack> base) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.m_46472_() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        return ChestData.unwrap((ChestData)manager.m_164861_(ChestData.loadWrapper(id, (ResourceKey<Level>)world.m_46472_(), pos), ChestData.ref_id((ResourceKey<Level>)world.m_46472_(), pos, id, base), ChestData.ID(id)), id, (ResourceKey<Level>)world.m_46472_(), pos);
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level level, UUID uuid, BlockPos pos, ServerPlayer player, IntSupplier sizeSupplier, Supplier<Component> displaySupplier, LootFiller filler, Supplier<ResourceLocation> tableSupplier, LongSupplier seedSupplier) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((ServerLevel)level, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, sizeSupplier, displaySupplier, tableSupplier, seedSupplier);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level level, UUID uuid, BlockPos pos, ServerPlayer player, BaseContainerBlockEntity blockEntity, LootFiller filler, Supplier<ResourceLocation> tableSupplier, LongSupplier seedSupplier) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((ServerLevel)level, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, blockEntity, tableSupplier, seedSupplier);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, UUID uuid, BlockPos pos, ServerPlayer player, RandomizableContainerBlockEntity tile, LootFiller filler) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((ServerLevel)world, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, tile);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, UUID uuid, NonNullList<ItemStack> base, ServerPlayer player, BlockPos pos, RandomizableContainerBlockEntity tile) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getReferenceContainerData((ServerLevel)world, pos, uuid, base);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
        }
        return inventory;
    }

    public static boolean clearInventories(UUID uuid) {
        DimensionDataStorage data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129783_();
        if (world == null) {
            LootrAPI.LOG.error("Overworld is null while attempting to clear inventories for '" + uuid.toString() + "'; Lootr cannot clear inventories.");
            return false;
        }
        Path dataPath = world.m_7654_().m_129843_(new LevelResource("data")).resolve("lootr");
        ArrayList ids = new ArrayList();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(o -> {
                if (Files.isRegularFile(o, new LinkOption[0])) {
                    String fileName = o.getFileName().toString();
                    if (fileName.startsWith("Lootr-")) {
                        return;
                    }
                    ids.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            ChestData chestData = (ChestData)data.m_164858_(ChestData::load, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.m_77762_();
        }
        LootrAPI.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, LootrChestMinecartEntity cart, ServerPlayer player, LootFiller filler) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getEntityData((ServerLevel)world, cart.m_20183_(), cart.m_20148_());
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        return inventory;
    }

    public static void refreshInventory(Level level, BlockPos pos, UUID uuid, ServerPlayer player) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getContainerData((ServerLevel)level, pos, uuid);
        if (data == null) {
            return;
        }
        data.clear();
        data.m_77762_();
    }

    public static void refreshInventory(Level world, BlockPos pos, UUID uuid, NonNullList<ItemStack> base, ServerPlayer player) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getReferenceContainerData((ServerLevel)world, pos, uuid, base);
        if (data == null) {
            return;
        }
        data.clear();
        data.m_77762_();
    }

    public static void refreshInventory(Level world, LootrChestMinecartEntity cart, ServerPlayer player) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getContainerData((ServerLevel)world, cart.m_20183_(), cart.m_20148_());
        if (data == null) {
            return;
        }
        data.clear();
        data.m_77762_();
    }
}

